<?php

namespace App\Controllers;

use App\Models\ArticlesExpeditionsModel;
use App\Models\ArticlesCommandesClientModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ExportDouanesItalie extends BaseController
{
    public function index()
    {

        $output = [
            "page_controller" => 'ExportDouanesItalie',
            "page_route" => 'export-douanes-italie',
            "page_button" => '',
            "page_title" => "Export commandes Italie"
        ];

        echo view('export_douanes_italie', $output);

    }

    public function export()
    {
        $startDate = $this->request->getPost('start_date');
        $endDate = $this->request->getPost('end_date');

        if (!$startDate || !$endDate) {
            return redirect()->back()->with('error', 'Veuillez fournir une date de début et une date de fin.');
        }

        $expeditionsModel = new ArticlesExpeditionsModel();
        $articlesModel = new ArticlesCommandesClientModel();

        // Étape 1 : Récupérer les commandes expédiées
        $expeditions = $expeditionsModel->getExpeditions($startDate, $endDate);
        $commandes = array_column($expeditions, 'Réf. Commande');

        if (empty($commandes)) {
            return redirect()->back()->with('error', 'Aucune commande expédiée trouvée pour la période sélectionnée.');
        }

        // Étape 2 : Récupérer les articles pour les commandes expédiées
        $articles = $articlesModel->getArticlesByCommandes($commandes);

        if (empty($articles)) {
            return redirect()->back()->with('error', 'Aucun article trouvé pour les commandes expédiées.');
        }

        // Étape 3 : Générer le fichier Excel
        $spreadsheet = new Spreadsheet();

        // Feuille A
        $sheetA = $spreadsheet->getActiveSheet();
        $sheetA->setTitle('Feuille A');
        $sheetA->fromArray(['Client Id', 'Réf Article', 'Désignation', 'ML', 'MG', 'Quantité'], null, 'A1');

        $row = 2;
        foreach ($articles as $data) {
            $sheetA->fromArray([
                $data['Client_Id'],
                $data['Ref_Article'],
                $data['Désignation'],
                $data['ML'],
                $data['MG'],
                $data['Quantité']
            ], null, "A$row");
            $row++;
        }

        // Feuille B
        $sheetB = $spreadsheet->createSheet();
        $sheetB->setTitle('Feuille B');
        $sheetB->fromArray(['Client Id', 'Réf Article', 'Désignation', 'ML', 'MG', 'Quantité Totale'], null, 'A1');

        $row = 2;
        foreach ($articles as $data) {
            $sheetB->fromArray([
                $data['Client_Id'],
                $data['Ref_Article'],
                $data['Désignation'],
                $data['ML'],
                $data['MG'],
                $data['Quantité']
            ], null, "A$row");
            $row++;
        }

        // Nom du fichier
        $fileName = "Export_Commandes_" . date('Ymd_His') . ".xlsx";

        // En-têtes HTTP pour téléchargement
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');

        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }
}
