<?php

namespace App\Entities;

use CodeIgniter\Entity;

class LancementsEntity extends Entity
{
	protected $datamap = [
        "lancement" => "lancement",
        "marque" => "marque",
        "preco" => "preco",
        "date_preco" => "date_preco",
        "preco_activee" => "preco_activee",
        "date_lancement" => "qate_lancement",
        "date_reception" => "date_reception",

	];

	protected $dates = [];
    
	protected $casts = [];	

    public function setTotalamount($value)
    {
        $this->attributes["total_amount"] = convert_money($value);
        return $this;
    }	

    public function setTaxed($value)
    {
        if($value == "on" || $value == "YES") {
            $ret = "YES";
        } else {
            $ret = "NO";
        }
        $this->attributes["taxed"] = $ret;
        return $this;
    }	

    public function getTaxed()
    {
        $ret = null;
        if(array_key_exists("taxed", $this->attributes)) {
            $attribute = $this->attributes["taxed"];
            if($attribute == "on" || $attribute == "YES") {
                $ret = "YES";
            }
        }
        return $ret;
    }
                
    public function setDoclist($value)
	{
        if(is_array($value)) {
            $this->attributes["doc_list"] = ($value != "") ? implode("|", $value): "";
        } else {
            $this->attributes["doc_list"] = $value;
        }
        return $this;
    }
}
