<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => $page_title, "url" => admin_url($page_route)];
    $list[] = ["text" => str("form")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">
                <?= inputDate(["src" => $data, "id" => "trans_date", "label" => str("sales_trans_date"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">            
                <?php                    
                    $columns[] = ["field" => str("sales_customer_id"), "class" => "width-85"];
                    echo selectPopup(["src" => $data, "id" => "customer_id", "label" => str("sales_customer_id"), "text" => "customer_id_txt", "column" => $columns]);
                ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= dropdownList(["src" => $data, "id" => "product_id", "label" => str("sales_product_id"), "list" => $product_id_list]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputText(["src" => $data, "id" => "description", "label" => str("sales_description")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputNumber(["src" => $data, "id" => "qty", "label" => str("sales_qty"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= inputMoney(["src" => $data, "id" => "total_amount", "label" => str("sales_total_amount"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= checkNoYes(["src" => $data, "id" => "taxed", "label" => str("sales_taxed")]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= checkbox(["src" => $data, "id" => "doc_list", "label" => str("sales_doc_list"), "list" => $doc_list_list]); ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= dropdownList(["src" => $data, "id" => "status", "label" => str("sales_status"), "list" => $status_list]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#trans_date").val() == "") {error("Transaction date must be filled"); ret = false}
        if($("#customer_id").val() == "") {error("Customer must be filled"); ret = false}
        if($("#qty").val() == "") {error("Qty must be filled"); ret = false}
        if($("#total_amount").val() == "") {error("Total amount must be filled"); ret = false}
        return ret;
    }

    function deleteSales() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete/";
        var id = $("#row_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
    function selectpopup_customer_id() {
        var tableId = "#Popup_customer_id";
        var url = "<?= admin_url("select-popup/customer_id") ?>";
        var where = "";
        var field_id = "customer_id";
        $(tableId).dataTable().fnDestroy()
        var datatable = $(tableId).DataTable({ 
            "processing": true, 
            "serverSide": true, 
            "ordering": false,
            "dom": "t<\"bottom datatable-ext\"fp>",
            "ajax": {
                "url": url,
                "type": "POST",
                "data": function(data) {
                    data.sistemator_token = $("#sistemator_token").val();
                    data.where = where;
                    data.field_id = field_id;
                },
                "dataSrc": function(response) {
                    $("#sistemator_token").val(response.sistemator_token);                
                    return response.data;
                }
            }
        });   
    } 

    function modal_after_select(id) {
        if(id == "customer_id") {
            
        }
    }
    
</script>

<?= $this->endSection() ?>