<?= $this->extend('web_layout/admin/preview_layout') ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-4">
                <?= printDate(["value" => $data->trans_date, "label" => str("sales_trans_date")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printText(["value" => $data->customer_id_txt, "label" => str("sales_customer_id")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printText(["value" => $data->product_id_txt, "label" => str("sales_product_id")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printText(["value" => $data->description, "label" => str("sales_description")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printNumber(["value" => $data->qty, "label" => str("sales_qty")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printText(["value" => $data->total_amount, "label" => str("sales_total_amount")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printNoYes(["value" => $data->taxed, "label" => str("sales_taxed")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printCheckbox(["value" => $data->doc_list, "label" => str("sales_doc_list")]) ?>
            </div>
            <div class="col-md-4 mb-4">
                <?= printText(["value" => $data->status, "label" => str("sales_status")]) ?>
            </div>            
            <?= formTitle(str("data_modified")) ?>            
            <div class="col-md-3 mb-4">
                <?= printDatetime(["value" => $data->created_date, "label" => str("created_date")]) ?>
            </div>
            <div class="col-md-3 mb-4">
                <?= printText(["value" => $data->created_by, "label" => str("created_by")]) ?>
            </div>
            <div class="col-md-3 mb-4">
                <?= printDatetime(["value" => $data->modified_date, "label" => str("modified_date")]) ?>
            </div>
            <div class="col-md-3 mb-4">
                <?= printText(["value" => $data->modified_by, "label" => str("modified_by")]) ?>
            </div>
        </div>
    </div>       
</div>  

<?= $this->endSection() ?>
