<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => str("menu_home"), "url" => admin_url($page_route)];
    $list[] = ["text" => str("change_password")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url("save-change-password"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-lg-4 col-xs-12">
        <div class="row">
            <div class="col-md-12 mb-5">
                <?= inputPassword(["id" => "new_password", "label" => str("new_password"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-12 mb-5">
                <?= inputPassword(["id" => "confirm_password", "label" => str("confirm_password"), "mandatory" => 1]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#new_password").val() == "") {error("New password must be filled"); ret = false}
        if($("#confirm_password").val() == "") {error("Confirm password must be filled"); ret = false}
        if($("#confirm_password").val() != $("#new_password").val()) {error("New password and Confirm password must be same"); ret = false}
        return ret;
    }

    function deleteSysUser() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete/";
        var id = $("#row_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>