<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => str("menu_home"), "url" => admin_url($page_route)];
    $list[] = ["text" => str("edit_profile")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url("save-edit-profile"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
    ?>
    <div class="col-lg-4 col-xs-12">
        <div class="row">
            <div class="col-md-12 mb-5">
                <?= inputText(["src" => $data, "id" => "name", "label" => str("sysuser_name"), "mandatory" => 1]); ?>
            </div>
            <div class="col-md-12 mb-5">
                <?= inputText(["src" => $data, "id" => "title", "label" => str("sysuser_title")]); ?>
            </div>
            <div class="col-md-12 mb-5">
                <?= inputText(["src" => $data, "id" => "email", "label" => str("sysuser_email"), "mandatory" => 1]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#user_access_id").val() == "") {error("User access must be filled"); ret = false}
        if($("#name").val() == "") {error("Name must be filled"); ret = false}
        if($("#email").val() == "") {error("Email must be filled"); ret = false}
        if($("#user_id").val() == "") {error("User Id must be filled"); ret = false}
        return ret;
    }

    function after_exec(ret) {
        var url = "<?= admin_url($page_route) ?>";
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
</script>

<?= $this->endSection() ?>