<?= $this->extend('web_layout/admin/form_layout') ?>

<?= $this->section('content') ?>

<?php
    $list[] = ["text" => $page_title, "url" => admin_url($page_route)];
    $list[] = ["text" => str("form"), "url" => admin_url($page_route."/form/".$row_id)];
    $list[] = ["text" => str("sysuseraccessaccess")];
    echo breadcrumb($list);
?>

<div class="row">
    <?php                            
        echo form_open_multipart(admin_url($page_route."/save-access"), ["id" => "form_input"]);
        echo inputHidden(["sistemator_token" => csrf_hash()]);
        echo inputHidden(["row_id" => $row_id]);
        echo inputHidden(["line_id" => $line_id]);
    ?>
    <div class="col-12">
        <div class="row">
            <div class="col-md-4 mb-5">            
                <?php                    
                    $columns[] = ["field" => str("sysuseraccessaccess_menu_id"), "class" => "width-85"];
                    echo selectPopup(["src" => $data, "id" => "menu_id", "label" => str("sysuseraccessaccess_menu_id"), "text" => "menu_id_txt", "column" => $columns]);
                ?>
            </div>
            <div class="col-md-4 mb-5">
                <?= dropdownList(["src" => $data, "id" => "access_control", "label" => str("sysuseraccessaccess_access_control"), "list" => $access_control_list, "mandatory" => 1]); ?>
            </div>
        </div>
    </div>   
    <?= form_close() ?>     
</div>   

<?= $this->endSection() ?>

<?= $this->section('javascript') ?>

<script type="text/javascript">
    function page_load() {
        
    }

    function validation() {
        var ret = true;
        if($("#menu_id").val() == "") {error("Menu must be filled"); ret = false}
        if($("#access_control").val() == "") {error("Access must be filled"); ret = false}
        return ret;
    }

    function deleteAccess() {
        var csrf = $("#sistemator_token").val();
        var url = "<?= admin_url($page_route) ?>/delete-access/";
        var id = $("#line_id").val();
        exec_delete(csrf, url, id);          
    }

    function after_exec(ret) {
        var row_id = $("#row_id").val();
        var url = "<?= admin_url($page_route."/form/") ?>" + row_id;
        var data = JSON.parse(ret); 
        var msg = data["msg"];
        var status = data["status"];
        var token = data["sistemator_token"];
        $("#sistemator_token").val(token);

        if(status == 1) {
            success(msg, url); 
        } else {
            error(msg);              
        }
    }
    
    function selectpopup_menu_id() {
        var tableId = "#Popup_menu_id";
        var url = "<?= admin_url("select-popup/menu_id") ?>";
        var where = "";
        var field_id = "menu_id";
        $(tableId).dataTable().fnDestroy()
        var datatable = $(tableId).DataTable({ 
            "processing": true, 
            "serverSide": true, 
            "ordering": false,
            "dom": "t<\"bottom datatable-ext\"fp>",
            "ajax": {
                "url": url,
                "type": "POST",
                "data": function(data) {
                    data.sistemator_token = $("#sistemator_token").val();
                    data.where = where;
                    data.field_id = field_id;
                },
                "dataSrc": function(response) {
                    $("#sistemator_token").val(response.sistemator_token);                
                    return response.data;
                }
            }
        });   
    } 

    function modal_after_select(id) {
        if(id == "menu_id") {
            
        }
    }
    
</script>

<?= $this->endSection() ?>