<!doctype html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= session()->get("application_name")." | ".session()->get("company_name") ?></title>
        <link rel="shortcut icon" href="<?= asset_uploaded()."/".session()->get("web_icon") ?>">
        <link rel="stylesheet" href="<?= base_url() ?>/assets/css/pace.css"type="text/css" />
        <!-- <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" /> -->
        <link href="<?= base_url() ?>/assets/fontawesome/all.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/bootstrap.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/style.css" id="app-style" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/custom.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>/assets/css/loading.css" rel="stylesheet" type="text/css" />

    </head>

    <body class="auth-color">
    
        <div id="loading_bar" class="loading loading-hide">Loading&#8230;</div>

        <div class="my-5 pt-5">
            <div class="container">                
                <?= $this->renderSection('content') ?>	
            </div>
        </div>

        <script src="<?= base_url() ?>/assets/libs/jquery/jquery.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?= base_url() ?>/assets/libs/sweetalert2/sweetalert2.min.js"></script>
        <script src="<?= base_url() ?>/assets/js/pages/sweetalert.init.js"></script>
        <script src="<?= base_url() ?>/assets/libs/pace-js/pace.min.js"></script>
        <script src="<?= base_url() ?>/assets/js/form.js"></script>

        <script type="text/javascript">
            $(document).ready(function() {
				'use strict';
                page_load();                   

                $('input').keyup(function(event) {
                    if (event.which === 13)
                    {
                        event.preventDefault();
                        auth('form_input', 'btn_save');
                    }
                });
            });
        </script>

        <?= $this->renderSection('javascript') ?>	

    </body>
</html>
